# coding: UTF-8

import myvisa

# 1秒でタイムアウト
DEFAULT_TIMEOUT = 1000

def main():
    # myvisaクラスのインスタンス化
    visa = myvisa.Myvisa()

    # ライブラリ情報の取得
    print(visa.get_lib())

    # 接続
    while True:
        print("VISA Address? (View resources with no input)")
        resource = input()
        # 入力なしでリソース一覧表示
        if resource == "":
            print("Searching For Resources ...")
            print(visa.get_resources())
        else:
        #オープン
            if not visa.open(resource):
                return
            break
    
    # コマンド送受信
    while True:
        print("Please enter the command (Exit with no input)")
        command = input()
        # 入力なしで終了
        if command == "":
            break

        visa.send_query_msg(command, DEFAULT_TIMEOUT)   # 送受信
        if "?" in command :                             # コマンドに?が含まれる場合
            print(visa.msg_buf)                         # 受信データ出力

    # クローズ    
    visa.close()

if __name__ == '__main__':
  main()
